<?php get_header(); ?>
<div id="content">
<div id="contentmiddle3">
<div class="sm"><?php _e('You are here:', 'ines') ?> <a href="/"><?php _e('Home', 'ines') ?></a> &raquo; Groups</div>
<div class="sl"></div>

	<?php do_action( 'template_notices' ) // (error/success feedback) ?>
	
	<?php if ( bp_has_groups() ) : while ( bp_groups() ) : bp_the_group(); ?>
	
	<div class="left-menu">
		<?php locate_template( array( 'groups/single/menu.php' ), true ) ?>
	</div>

	<div class="main-column">
		<div class="inner-tube">
			
			<div id="group-name">
				<h1><a href="<?php bp_group_permalink() ?>"><?php bp_group_name() ?></a></h1>
				<p class="status"><?php bp_group_type() ?></p>
			</div>

			<div class="bp-widget">
				<h4><?php _e( 'Forum' ); ?> <span><a href="#post-new-topic" title="<?php _e( 'Post New' ) ?>"><?php _e( 'Post New &rarr;' ) ?></a></span></h4>
				
				<form action="<?php bp_forum_action() ?>" method="post" id="forum-topic-form" class="standard-form">
					<?php if ( bp_has_topics() ) : ?>									
						
						<div class="pagination">
						
							<div id="post-count" class="pag-count">
								<?php bp_forum_pagination_count() ?>
							</div>
					
							<div class="pagination-links" id="topic-pag">
								<?php bp_forum_pagination() ?>
							</div>
						
						</div>
						
						<ul id="forum-topic-list" class="item-list">
						<?php while ( bp_topics() ) : bp_the_topic(); ?>
							<li<?php if ( bp_get_the_topic_css_class() ) : ?> class="<?php bp_the_topic_css_class() ?>"<?php endif; ?>>

								<a class="topic-avatar" href="<?php bp_the_topic_permalink() ?>" title="<?php bp_the_topic_title() ?> - <?php _e( 'Permalink' ) ?>"><?php bp_the_topic_last_poster_avatar( 'width=30&height=30') ?></a>
								<a class="topic-title" href="<?php bp_the_topic_permalink() ?>" title="<?php bp_the_topic_title() ?> - <?php _e( 'Permalink' ) ?>"><?php bp_the_topic_title() ?></a> 
								<span class="small topic-meta">(<?php bp_the_topic_total_post_count() ?> &rarr; <?php printf( __( '%s ago' ), bp_get_the_topic_time_since_last_post() ) ?>)</span>
								<span class="small latest topic-excerpt"><?php bp_the_topic_latest_post_excerpt() ?></span>
								
								<?php if ( bp_group_is_admin() || bp_group_is_mod() ) : ?>
									<div class="admin-links"><?php bp_the_topic_admin_links() ?></div>
								<?php endif; ?>
							</li>
						<?php endwhile; ?>
						</ul>
					<?php else: ?>

						<div id="message" class="info">
							<p><?php _e( 'There are no topics for this group forum.' ) ?></p>
						</div>

					<?php endif;?>
					
					<?php if ( ( is_user_logged_in() && 'public' == bp_get_group_status() ) || bp_group_is_member() ) : ?>
				
						<div id="post-new-topic">

							<?php do_action( 'groups_forum_new_topic_before' ) ?>
							
							<?php if ( !bp_group_is_member() ) : ?>
								<p><?php _e( 'You will auto join this group when you start a new topic.' ) ?></p>
							<?php endif; ?>

							<a name="post-new"></a>
							<p><strong><?php _e( 'Post a New Topic:' ) ?></strong></p>
							
							<label><?php _e( 'Title:' ) ?></label>
							<input type="text" name="topic_title" id="topic_title" value="" />
				
							<label><?php _e( 'Content:' ) ?></label>
							<textarea name="topic_text" id="topic_text"></textarea>
					
							<label><?php _e( 'Tags (comma separated):' ) ?></label>
							<input type="text" name="topic_tags" id="topic_tags" value="" />

							<?php do_action( 'groups_forum_new_topic_after' ) ?>
					
							<p class="submit"><input type="submit" name="submit_topic" id="submit" value="<?php _e( 'Post Topic' ) ?>" /></p>
							
							<?php wp_nonce_field( 'bp_forums_new_topic' ) ?>
						</div>
					
					<?php endif; ?>
				</form>
				
			</div>
		
		</div>
	</div>
	
	<?php endwhile; endif; ?>
</div>

<?php get_template_part('bar'); ?>
</div>
</div>
<?php get_footer(); ?>