<?php
//----------------------------------------------------------------------//
// Initiate the plugin to add custom post type of "places" and "events"
//----------------------------------------------------------------------//
add_action("init", "custom_posttype_menu_wp_admin1");
function custom_posttype_menu_wp_admin1()
{
//===============Custom SECTION START================
register_post_type(	'videos', 
				array(	'label' 			=> __('Videos'),
						'labels' 			=> array(	'name' 					=> __('Video'),
														'singular_name' 		=> __('Video'),
														'add_new' 				=> __('Add Video'),
														'add_new_item' 			=> __('Add New Video'),
														'edit' 					=> __('Edit'),
														'edit_item' 			=> __('Edit Video'),
														'new_item' 				=> __('New Video'),
														'view_item'				=> __('View Video'),
														'search_items' 			=> __('Search Videos'),
														'not_found' 			=> __('No Videos found'),
														'not_found_in_trash' 	=> __('No Videos found in trash')	),
						'public' 			=> true,
						'can_export'		=> true,
						'show_ui' 			=> true, // UI in admin panel
						'_builtin' 			=> false, // It's a custom post type, not built in
						'_edit_link' 		=> 'post.php?post=%d',
						'capability_type' 	=> 'post',
						'menu_icon' 		=> get_bloginfo('template_url').'/images/favicon.ico',
						'hierarchical' 		=> false,
						'rewrite' 			=> array("slug" => "videos"), // Permalinks
						'query_var' 		=> "videos", // This goes to the WP_Query schema
						'supports' 			=> array(	'title',
														'author', 
														'excerpt',
														'thumbnail',
														'comments',
														'editor', 
														'trackbacks',
														'custom-fields',
														'revisions') ,
						'show_in_nav_menus'	=> true ,
						'taxonomies'		=> array('videoscategory','videostags')
					)
				);

// Register custom taxonomy
register_taxonomy(	"videoscategory", 
				array(	"videos"	), 
				array (	"hierarchical" 		=> true, 
						"label" 			=> "Category", 
						'labels' 			=> array(	'name' 				=> __('Category'),
														'singular_name' 	=> __('Category'),
														'search_items' 		=> __('Search Category'),
														'popular_items' 	=> __('Popular Category'),
														'all_items' 		=> __('All Category'),
														'parent_item' 		=> __('Parent Category'),
														'parent_item_colon' => __('Parent Category:'),
														'edit_item' 		=> __('Edit Category'),
														'update_item'		=> __('Update Category'),
														'add_new_item' 		=> __('Add New Category'),
														'new_item_name' 	=> __('New Make Category')	), 
						'public' 			=> true,
						'show_ui' 			=> true,
						"rewrite" 			=> true	)
				);
register_taxonomy(	"videostags", 
				array(	"videos"	), 
				array(	"hierarchical" 		=> false, 
						"label" 			=> "Tags", 
						'labels' 			=> array(	'name' 				=> __('Tags'),
														'singular_name' 	=> __('Tags'),
														'search_items' 		=> __('Video Tags'),
														'popular_items' 	=> __('Popular Video Tags'),
														'all_items' 		=> __('All Video Tags'),
														'parent_item' 		=> __('Parent Video Tags'),
														'parent_item_colon' => __('Parent Video Tags:'),
														'edit_item' 		=> __('Edit Video Tags'),
														'update_item'		=> __('Update Video Tags'),
														'add_new_item' 		=> __('Add New Video Tags'),
														'new_item_name' 	=> __('New Video Tags Name')	),  
						'public' 			=> true,
						'show_ui' 			=> true,
						"rewrite" 			=> true	)
				);
}
//===============Custom SECTION END================

/////The filter code to get the custom post type in the RSS feed
function myfeed_request($qv) {
	if (isset($qv['feed']))
		$qv['post_type'] = get_post_types();
	return $qv;
}
add_filter('request', 'myfeed_request');

?>