<?php get_header(); ?>
<div id="container">
<?php do_action( 'bp_before_directory_forums_content' ) ?>		
<div id="contents">
<div id="content">
	<div class="page" id="groups-directory-page">
	
			<form action="<?php echo site_url() . '/' ?>" method="post" id="forums-directory-form">

				<?php if ( bp_has_site_groups( 'type=most-forum-topics&max=6' ) ) : ?>

					<div id="popular-group-forum-listing" class="widget">
						<h2 class="widgettitle"><?php _e( 'Popular Group Forums', 'buddypress' ) ?></h2>
						<div class="widget-content">
						<?php do_action( 'bp_before_directory_popular_group_forums' ) ?>		

						<?php while ( bp_site_groups() ) : bp_the_site_group(); ?>

							<div class="group-forum">
								<div class="item-avatar">
									<a href="<?php bp_the_site_group_link() ?>/forum/"><?php bp_the_site_group_avatar_thumb() ?></a>
								</div>

								<div class="item">
									<div class="item-title"><a href="<?php bp_the_site_group_link() ?>/forum/"><?php bp_the_site_group_name() ?></a> (<?php bp_the_site_group_forum_topic_count( 'showtext=true' ) ?>, <?php bp_the_site_group_forum_post_count( 'showtext=true' ) ?>)</div>
									<div class="item-meta desc"><?php bp_the_site_group_description_excerpt() ?></div>

									<?php do_action( 'bp_directory_popular_group_forums_item' ) ?>
								</div>
							</div>

						<?php endwhile; ?>

						<?php do_action( 'bp_after_directory_popular_group_forums' ) ?>		
						</div><!-- end of widget content -->
					</div>
					
				<?php endif; ?>

				<div id="forums-directory-listing" class="directory-listing widget">
					<h2 class="widgettitle"><?php _e( 'Latest Forum Topics', 'buddypress' ) ?></h2>
					
					<div id="forum-dir-list" class="widget-content">
						
						<?php do_action( 'bp_before_directory_forums_topic_filters' ) ?>
						
						<div id="global-forum-topic-filters">
							<ul>
								<li<?php if ( '' == bp_current_action() && !isset( $_GET['fs'] ) ) : ?> class="selected"<?php endif; ?> id="forums-newest"><a href="<?php bp_newest_forum_topics_link() ?>" title="<?php _e( 'Newest Topics', 'buddypress' ) ?>"><?php _e( 'Newest Topics', 'buddypress') ?></a></li>
								<li<?php if ( 'popular' == bp_current_action() ) : ?> class="selected"<?php endif; ?> id="forums-popular"><a href="<?php bp_popular_forum_topics_link() ?>" title="<?php _e( 'Most Popular Topics', 'buddypress' ) ?>"><?php _e( 'Most Popular Topics', 'buddypress') ?></a></li>
								<li<?php if ( 'unreplied' == bp_current_action() ) : ?> class="selected"<?php endif; ?> id="forums-unreplied"><a href="<?php bp_unreplied_forum_topics_link() ?>" title="<?php _e( 'Unreplied Topics', 'buddypress' ) ?>"><?php _e( 'Unreplied Topics', 'buddypress') ?></a></li>
		
								<?php if ( is_user_logged_in() ) : ?>
									<li<?php if ( 'personal' == bp_current_action() ) : ?> class="selected"<?php endif; ?> id="forums-personal"><a href="<?php bp_my_forum_topics_link() ?>" title="<?php _e( 'Topics I have started or replied to', 'buddypress' ) ?>"><?php _e( 'My Topics', 'buddypress') ?></a></li>
								<?php endif; ?>
								
								<?php if ( 'tag' == bp_current_action() ) : ?>
									<li class="selected" id="forums-tag"><a href="<?php bp_newest_forum_topics_link() ?>" title="<?php _e( 'Tag', 'buddypress' ) ?>"><?php printf( __( 'Tagged: %s', 'buddypress' ), bp_get_forums_tag_name() ) ?></a></li>
								<?php endif; ?>
								
								<?php if ( isset( $_GET['fs'] ) ) : ?>
									<li class="selected" id="forums-search"><a href="<?php bp_newest_forum_topics_link() ?>" title="<?php _e( 'Search', 'buddypress' ) ?>"><?php printf( __( 'Matching: %s', 'buddypress' ), attribute_escape( $_GET['fs'] ) ) ?></a></li>
								<?php endif; ?>
								
								<?php do_action( 'bp_directory_forums_topic_filters' ) ?>
							</ul>								
						</div>
						
						<?php do_action( 'bp_after_directory_forums_topic_filters' ) ?>

						<?php locate_template( array( 'directories/forums/forums-loop.php' ), true ) ?>
					</div>

				</div>
			
				<?php do_action( 'bp_directory_forums_content' ) ?>

			</form>
	
		</div>
	</div>
	<?php do_action( 'bp_after_directory_forums_content' ) ?>		
	<?php do_action( 'bp_before_directory_forums_sidebar' ) ?>		
	
	<?php get_sidebar("forums-directory");?>
	<br class="clear" />
</div>

</div><!--end of container-->
	
<?php get_footer(); ?>
